k6 `v0.57.0` is here 🎉! This release includes:

- Introducing helpers for functional testing.
- The `k6 new` command now supports templates and ProjectIDs.
- The `k6/experimental/csv` module gets a new `asObjects` option.
- We no longer support the `k6/experimental/browser` module, in favor of `k6/browser`.
- Moving most of non-public APIs to the `internal` package.

## Breaking changes

- [#4161](https://github.com/grafana/k6/pull/4161) Drops `k6/experimental/browser`. If you're still using it, follow the [instructions](https://grafana.com/docs/k6/latest/using-k6-browser/migrating-to-k6-v0-52/) to move to the graduated and stable `k6/browser` module.
- [#4133](https://github.com/grafana/k6/pull/4133) Moves all not publicly used APIs in `internal` package. This was based on the publicly available extensions for k6 and may break private ones. More APIs will likely be removed or updated in follow-up releases after this more mechanical change.
- [#4292](https://github.com/grafana/k6/pull/4292) TypeScript is automatically supported and recognized if the script files use the `.ts` extension. It also deprecates `experimental_enhanced` compatibility mode as it is no longer necessary.

## New features

### New functional testing focused official jslib [k6-testing](https://github.com/grafana/k6-jslib-testing)

The k6 team has been developing a new official jslib dedicated to functional testing. While it is still under active development and will potentially see breaking changes, the set of APIs and behaviors it offers are meant to make their way into k6 eventually, and it is now available for early feedback.

[k6-testing](https://github.com/grafana/k6-jslib-testing) is a k6 JavaScript library that offers a seamless way to write functional tests in k6, using a Playwright-compatible assertions API. It exposes an `expect` function, with which assertions can be performed using specific matchers that reflect the expected results.
Unlike current k6's `check` when `expects` assertions fail, the test will immediately fail with a clear error message, including the expected and actual values in a similar fashion to what users would observe when using Playwright assertions. 

[There are many generic matchers](https://github.com/grafana/k6-jslib-testing?tab=readme-ov-file#3-standard-assertions) (and more to come), such as `toEqual`, `toBe`, or `toBeTruthy`, to only name a few, that can be used to assert conditions during a k6 test.

```javascript
import { expect } from 'https://jslib.k6.io/k6-testing/0.2.0/index.js';

export default function () {
    const response = http.get('https://test.k6.io');
    expect(response.status).toEqual(200);
    expect(response.body).toBeTruthy();
    expect(response.json()).toEqual(JSON.stringify({ message: 'Hello, world!' }));
}
```

[k6-jslib-testing](https://github.com/grafana/k6-jslib-testing) also includes browser-specific async matchers that wait until the expected condition is met such as `toBeVisible`, `toBeDisabled`, or `toBeChecked`, to name a few.

```javascript
import { expect } from "https://jslib.k6.io/k6-testing/0.2.0/index.js";
import { browser } from "k6/browser";

export const options = {
  scenarios: {
    ui: {
      executor: "shared-iterations",
      options: {
        browser: {
          type: "chromium",
        },
      },
    },
  },
};

export default async function () {
  const page = await browser.newPage();

  try {
    // Navigate to the page
    await page.goto("https://test.k6.io/my_messages.php");

    // Type into the login input field: 'testlogin'
    const loc = await page.locator('input[name="login"]');
    await loc.type("testlogin");

    // Assert that the login input field is visible
    await expect(page.locator('input[name="login"]')).toBeVisible();

    // Expecting this to fail as we have typed 'testlogin' into the input instead of 'foo'
    await expect(page.locator('input[name="login"]')).toHaveValue("foo");
  } finally {
    await page.close();
  }
}
```

It is currently available as part of the [jslib.k6.io](https://jslib.k6.io) repository and is available to use in your k6 tests by adding the following import:

```javascript
import { expect } from "https://jslib.k6.io/k6-testing/0.2.0/index.js";
```

Try it out and give us feedback or contribute to the project on the [k6-jslib-testing repository](https://github.com/grafana/k6-jslib-testing)!

### `--template` and `--project-id` flags for `k6 new` command [#4153](https://github.com/grafana/k6/pull/4153)

The `k6 new` command has been revamped to provide an improved experience when scaffolding new k6 tests. It now supports a `--template` flag with options such as `minimal`, `protocol`, and `browser`, letting you generate a script tailored to your specific use case.

The command also now accepts a `--project-id` flag, which allows you to easily parameterize the test's Grafana Cloud configuration.

```sh
# Create a new k6 script using the 'protocol' template
$ k6 new --template protocol

# Create a Grafana k6 cloud-ready script with a specific project ID
$ k6 new --project-id 12345
```

### New `asObjects` option in `k6/experimental/csv` module [#4295](https://github.com/grafana/k6/pull/4295)

The CSV module's parsing operations now support the `asObjects` option, which enables parsing CSV data into JavaScript objects instead of arrays of strings (the default behavior).

When `asObjects` is set to `true`, the module parses CSV data into objects where:

- Column names from the header row become object keys.
- Column values become the corresponding object values.
- An error is thrown if no header row exists or if options modify the parsing start point.

With the option set to `true`,

```js
import http from 'k6/http';
import csv from 'k6/experimental/csv';

const csvData = csv.parse('data.csv', { asObjects: true });
```

the following CSV file:

```csv
name,age,city
John,30,New York
Jane,25,Los Angeles
```

will be parsed into the following JavaScript objects:

```js
[
  { name: 'John', age: '30', city: 'New York' },
  { name: 'Jane', age: '25', city: 'Los Angeles' },
]
```

Refer to the [CSV module's documentation](https://grafana.com/docs/k6/latest/javascript-api/k6-experimental/csv/) for more information.

## UX improvements and enhancements

- [#4176](https://github.com/grafana/k6/pull/4176) Warns on using shorthand options when that override scenarios.
- [#4293](https://github.com/grafana/k6/pull/4293) Renames browser data directory name prefix from `xk6-browser-data-` to `k6browser-data-`.
- [#4513](https://github.com/grafana/k6/pull/4513) Adds support for `file` scheme URLs across file loading APIs - `open`, `k6/experimental/fs.open` and `k6/net/grpc.Client#load`.
- [#4517](https://github.com/grafana/k6/pull/4517) Switches from the legacy examples to quickpizza.grafana.com.

## Bug fixes

- [#4536](https://github.com/grafana/k6/pull/4536), [#4534](https://github.com/grafana/k6/pull/4534), [#4533](https://github.com/grafana/k6/pull/4533), [#4531](https://github.com/grafana/k6/pull/4531), [#4530](https://github.com/grafana/k6/pull/4530), [#4528](https://github.com/grafana/k6/pull/4528), [#4523](https://github.com/grafana/k6/pull/4523), [#4522](https://github.com/grafana/k6/pull/4522), [#4521](https://github.com/grafana/k6/pull/4521) Fix possible data races while using k6 browser's APIs.
- [#4174](https://github.com/grafana/k6/pull/4174) Fixes an NPD during a click, which could occur when either the load generator or chrome instance is under a lot of load.
- [#4192](https://github.com/grafana/k6/pull/4192) Fixes a memory leak in general event handling between components.
- [#4280](https://github.com/grafana/k6/pull/4280) Fixes an NPD by not disposing of the original handle.
- [#4288](https://github.com/grafana/k6/pull/4288) Cleans up browser download path artifacts after a test run.
- [#4532](https://github.com/grafana/k6/pull/4532) Fixes `--local-execution` runs by isolating `Archive`'s urls.

## Maintenance and internal improvements

- [#4184](https://github.com/grafana/k6/pull/4184) Fixes some browser Windows tests.
- [#4131](https://github.com/grafana/k6/pull/4131) Moves experimental WebSocket code into the k6 codebase.
- [#4143](https://github.com/grafana/k6/pull/4143) Fixes for k6packager workflow building image to do k6 releases.
- [#4172](https://github.com/grafana/k6/pull/4172) Drops Slack URL from the README.
- [#4173](https://github.com/grafana/k6/pull/4173) Updates dependencies in gRPC example server.
- [#4187](https://github.com/grafana/k6/pull/4187) Removes packaging folder from browser module - not needed after it was moved to the k6 codebase.
- [#4188](https://github.com/grafana/k6/pull/4188), [#4190](https://github.com/grafana/k6/pull/4190) Merge xk6-webcrypto extension code into k6.
- [#4189](https://github.com/grafana/k6/pull/4189) Uses `modulestest` to make experimental streams test simpler.
- [#4191](https://github.com/grafana/k6/pull/4191) Removes BaseEventEmitter from components that don't work with it.
- [#4201](https://github.com/grafana/k6/pull/4201) Tracks more dependencies to dependabot.
- [#4212](https://github.com/grafana/k6/pull/4212) Fixes gRPC tests after update to golang internal test certificates.
- [#4213](https://github.com/grafana/k6/pull/4213) Updates k6-taskqueue-lib to v0.1.3.
- [#4271](https://github.com/grafana/k6/pull/4271) Runs dependabot weekly instead of daily.
- [#4275](https://github.com/grafana/k6/pull/4275) Fixes the `browser` module working with reused VUs that originally weren't used in browser scenarios.
- [#4276](https://github.com/grafana/k6/pull/4276) REST API stays on while outputs are flushing, only stopping after that.
- [#4294](https://github.com/grafana/k6/pull/4294) TestStreamLogsToLogger: increase wait time to get less flakiness.
- [#4209](https://github.com/grafana/k6/pull/4209), [#4208](https://github.com/grafana/k6/pull/4208), [#4196](https://github.com/grafana/k6/pull/4196), [#4195](https://github.com/grafana/k6/pull/4195), [#4193](https://github.com/grafana/k6/pull/4193), [#4177](https://github.com/grafana/k6/pull/4177), [#4163](https://github.com/grafana/k6/pull/4163), [#4151](https://github.com/grafana/k6/pull/4151), [#4213](https://github.com/grafana/k6/pull/4213) Update direct dependencies.
- [#4198](https://github.com/grafana/k6/pull/4198) Adds a multiple forward-slash test case. Thanks, @apatruni, for the contribution!
- [#4504](https://github.com/grafana/k6/pull/4504), [#4506](https://github.com/grafana/k6/pull/4506) Update the golangci-lint version.
- [#4298](https://github.com/grafana/k6/pull/4298) Adds test coverage for configuration file's operations.
